	% DIGFI EXample 5.20
	clear all
	clc
	wc1T = 0.4*pi;	wc2T = 0.5*pi;	ws1T = 0.3*pi;	ws2T = 0.6*pi;
	dc = 0.01; ds1 = 0.01; ds2 = 0.003;
	N = 51;	M = (N+1)/2;	m = 1:M;	t = 2;
	Kp = 200;	Ks1 = 500;	Ks2 = 500;
	w1T = [linspace(wc1T, wc2T, Kp)];
	w1T = [w1T linspace(ws2T, pi, Ks2)];
	w2T = linspace(0, ws1T, Ks1);
	Kz = 3;
	wzT = [126 158 162]*pi/180;
	
	D1 = [ones(1, Kp) zeros(1, Ks2)];
	D2 = zeros(1, Ks1);
	Dz = zeros(1, Kz);
	W = [ones(1, Kp)/dc ones(1, Ks2)/ds2];
	efix = ones(1, Ks1)*ds1;
	A = [TRIGMAT(t, m, wzT) zeros(1, Kz)'];
	A = [A' [TRIGMAT(t, m, w1T) -1./W']']';
	A = [A' [-TRIGMAT(t, m, w1T) -1./W']']';
	A = [A' [TRIGMAT(t, m, w2T) zeros(1, Ks1)']']';
	A = [A' [-TRIGMAT(t, m, w2T) zeros(1, Ks1)']']';
	b = [Dz D1 -D1 D2+efix -D2+efix]';
	c = [zeros(1, M) 1]';
	%	x = lp(c, A, b, [], [], [], Kz);	% Old verson
	x = linprog(c, A, b, vlb, vub);
	h = [0.5*fliplr(x(1:M)') 0.5*x(1:M)'];
	
	subplot('position', [0.1 0.4 0.86 0.5]);	
	wT = linspace(0, pi, 1000);	
	H = freqz(h, 1, wT);			% Frequency response
	PLOT_MAG_Z_dB(wT, H, pi, 80, 'H')
	
	axes('position',[0.69 0.7 0.24 0.12]);
	wT = linspace(0.4*pi, 0.5*pi, 1000); 
	H = freqz(h, 1, wT);
	PLOT_MAG_Z_LS(wT, H, 0.99, 1.01, 'H')
	
	
